 aR  d  w f m
@     h	 oe       nSystem-wide
   NAME CpMessage

; This is the new CpMessage.ASM~Text~
; This contains the multi-tasking message passing routines

$NOLIST
$INCLUDE (`w`CcProm`Cp.Constant.Asm.Inc~Text~)
$LIST

DGROUP GROUP DATA
CGROUP GROUP CODE

    PUBLIC TellMessageWaiters, InterruptSend, CpSend, CpReceive

    EXTRN CpWhoAmI: FAR, Reschedule: FAR, HeadOfProcessQ: NEAR
    EXTRN DecTimedProcesses: NEAR, IncTimedProcesses: NEAR
    EXTRN ComputeTime: NEAR, FreeMe: NEAR, IntAllocate: FAR


DATA SEGMENT PUBLIC 'DATA'
DATA ENDS

CODE SEGMENT PUBLIC 'CODE'
  ASSUME CS:CGROUP, DS:DGROUP
$EJECT

;    TellMessageWaiters: PROCEDURE (procID, exitCode) CLEAN;
;        DCL procID   PidType;
;        DCL exitCode WORD;
;
;    This will see if any processes are waiting on a
;    message from a given procID.  If so they will be given an error
;    of eProcNotExist and will be placed back into the ready state.

exitCode EQU WORD PTR [BP+8]
procID   EQU WORD PTR [BP+10]

; let DS be curPID and DX be procID

TellMessageWaiters PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP
    PUSHF

    CLI

    CALL HeadOfProcessQ             ; DS := OsProcessQ.headOfQ

    MOV  DX, procID                 ; DX := procID

TellMessTopOfLoop:
    MOV  AX, DS
    CMP  AX, nullWord               ; DO WHILE curPid <> nullWord
    JE   TellMessDone

    MOV  AL, DS:pcbState
    MOV  AH, AL
    AND  AL, timedMask
    CMP  AL, messageWait            ;     IF ((curPcb.state AND timedMask) = messageWait
    JNE  TellMessNext
    CMP  DS:pcbSource, DX           ;     AND (pcb.source = procID) THEN DO;
    JNE  TellMessNext

    MOV  CX, exitCode
    MOV  DS:pcbNote, CX             ;         return exitCode to waiting process

    LES  BX, DWORD PTR DS:pcbPErrorOff
    MOV  WORD PTR ES:[BX], eProcNotExist ;    error := eProcNotExist

    CMP  AH, timedMessageWait       ;         IF curPcb.state = timedMessageWait THEN
    JNE  TellMess10

    CALL DecTimedProcesses          ;             timedProcesses := timedProcesses - 1

TellMess10:
    MOV  DS:pcbState, readyState    ;         curPCb.state := readyState

TellMessNext:
    MOV  DS, DS:next                ;     curPid := curPcb.next
    JMP  SHORT TellMessTopOfLoop

TellMessDone:
    POPF
    POP  BP
    POP  DS
    RET  4
TellMessageWaiters ENDP

PURGE procID, exitCode
$EJECT

;    InterruptSend: PROCEDURE (sourceProcID, destPID, messageType, note, pMsg, pError) BOOLEAN;

;
;    This will do the actual send work.
;    It assumes that interrupts are disabled.
;    NOTE: This routine can be called from an
;    interrupt service routine except when trying to send a NOTE.

pError       EQU DWORD PTR [BP+8]   ; sixth param
pMsg         EQU DWORD PTR [BP+12]  ; fifth param
note         EQU WORD  PTR [BP+16]  ; fourth param
messageType  EQU WORD  PTR [BP+18]  ; third param
destPid      EQU WORD  PTR [BP+20]  ; second param
sourceProcID EQU WORD  PTR [BP+22]  ; first param

; let DS point to the dest pcb

InterruptSend PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP

    XOR  CX, CX                     ; CX = 0 = eOK

    LES  BX, pError
    MOV  ES:[BX], CX                ; error = eOK

    DEC  CX                         ; CX = nullword

    MOV  DS, destPID                ; if a valid
    CMP  DS:pcbIdCode, processIdCode; process then
    JE   IntrSendTest0              ; keep going

    MOV  WORD PTR ES:[BX], eProcNotExist
    JMP  SHORT IntrSendReturnFalse  ; else return error

IntrSendTest0:
    MOV  AL, DS:pcbState            ; if dest is not
    AND  AL, timedMask              ; waiting for a
    CMP  AL, messageWait            ; message then
    JNE  IntrSendQueueTheMsg        ; queue the message

IntrSendTest1:
    MOV  AX, DS:pcbSource           ; if dest is
    CMP  AX, CX                     ; receiving from anyone
    JE   IntrSendTest2              ; or from this sender
    CMP  AX, sourceProcID           ; then check the 2nd
    JNE  IntrSendQueueTheMsg        ; set of tests

IntrSendTest2:
    MOV  AX, DS:pcbMessageType      ; if dest is
    CMP  AX, CX                     ; receiving any kind of message
    JE   IntrSendTheMsg             ; or the kind of message
    CMP  AX, messageType            ; being sent, then
    JNE  IntrSendQueueTheMsg        ; give them this message

IntrSendTheMsg:
    MOV  AX, note
    MOV  DS:pcbNote, AX             ; pcb.note = note

    LES  AX, pMsg
    MOV  DS:pcbPMessageSeg, ES
    MOV  DS:pcbPMessageOff, AX      ; pcb.pMsg = pMsg

    CMP  DS:pcbState, timedMessageWait
    JNE  IntrSendNotTimed           ; if timed msg wait
    CALL DecTimedProcesses          ; timedProc = timedProc - 1

IntrSendNotTimed:
    XOR  AX, AX                     ; readyState = 0
    MOV  DS:pcbState, AL            ; pcb.state = ready
    DEC  AX                         ; RETURN (TRUE, 0FFFFh) 
    JMP  SHORT IntrSendExit

IntrSendQueueTheMsg:
    CMP  DS:pcbMsgCount, CL         ; if msg count is < 255
    JNE  IntrSendRoomOnQ            ; then queue the message

    MOV  WORD PTR ES:[BX], eTooManyMsgs
    JMP  SHORT IntrSendReturnFalse  ; else return error

IntrSendRoomOnQ:
    PUSH DS                         ; save ptr to pcb

    MOV  SI, DS:pcbMsgTailOff
    MOV  DS, DS:pcbMsgTailSeg       ; DS:SI => msg queue tail

    LES  BX, pMsg

    MOV  ES:[BX+4], CX              ; set msgLink to nullword

    MOV  DS:[SI+4], ES
    MOV  DS:[SI+2], BX              ; link msg to current tail

    POP  DS                         ; restore ptr to pcb

    MOV  DS:pcbMsgTailSeg, ES
    MOV  DS:pcbMsgTailOff, BX       ; update pcb msg tail ptr

    INC  DS:pcbMsgCount             ; increment number msgs on queue

IntrSendReturnFalse:
    XOR  AX, AX                     ; RETURN (FALSE)

IntrSendExit:
    POP  BP
    POP  DS
    RET  16
InterruptSend ENDP

PURGE pError, pMsg, note, messageType, destPID, sourceProcID
$EJECT

;    CpSend: PROCEDURE (sourceProcID, destPID, messageType, note, pMsg, pError);

;
;    This will send a message from one process to another.  If the process is
;    already waiting for a message from this process (or anyone) then it will
;    be procesed and rescheduling will occur.  Otherwise the message will be placed
;    into the message queue of the receiving process.  The message types must also match up.

pError       EQU DWORD PTR [BP+8]   ; sixth param
pMsg         EQU DWORD PTR [BP+12]  ; fifth param
note         EQU WORD  PTR [BP+16]  ; fourth param
messageType  EQU WORD  PTR [BP+18]  ; third param
destPid      EQU WORD  PTR [BP+20]  ; second param
sourceProcID EQU WORD  PTR [BP+22]  ; first param

; let ES:BX point to msg most of the time
; let CL save state of 'noteOnly'

CpSend PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP
    PUSHF

    XOR  CX, CX                     ; noteOnly = FALSE (zero)

    LES  BX, pMsg
    MOV  AX, ES                     ; if the selector of pMsg
    INC  AX                         ; is not NULLWORD
    JNZ  CpSendMessage              ; then send the message

    STI                             ; ENABLE

    PUSH AX                         ; push systemPID (AX = 0 = systemPid)
    MOV  AL, 16
    PUSH AX                         ; push SIZE (msg)
    LDS  AX, pError
    PUSH DS                         ; push @error
    PUSH AX
    CALL IntAllocate                ; CALL IntAllocate

    XOR  CX, CX                     ; CX = eOK
    LDS  SI, pError                 ; if error is
    CMP  DS:[SI], CX                ; not eOK
    JNZ  CpSendExit                 ; then RETURN

    MOV  AX, sourceProcID
    MOV  ES:msgSource, AX           ; msg.uSourceProcID = sourceProcID

    MOV  AX, note
    MOV  ES:msgNote, AX             ; msg.uNote = note

    MOV  AX, messageType
    MOV  ES:msgClass, AX            ; msg.uMsgClass = messageClass

    DEC  CX                         ; noteOnly = TRUE (CX = 0FFFF, CL = 0FF)
    MOV  ES:msgDest, CX             ; msg.uDest = NULLWORD

CpSendMessage:
    PUSH CX                         ; save state of 'noteOnly'
    PUSH ES                         ; save selector => note msg area

    PUSH sourceProcID               ; push sourceProcID
    PUSH destPID                    ; push destPID
    PUSH messageType                ; push messageType
    PUSH note                       ; push note
    PUSH ES
    PUSH BX                         ; push @msg
    LDS  AX, pError
    PUSH DS                         ; push @error
    PUSH AX

    CLI                             ; disable interrupts

    CALL InterruptSend              ; CALL InterruptSend
    INC  AX                         ; if returns
    JNZ  CpSendAfterReschedule      ; TRUE then

    PUSH destPID
    CALL Reschedule                 ; reschedule

CpSendAfterReschedule:
    POP ES                          ; restore selector => note msg area
    POP CX                          ; restore state of 'noteOnly'

    INC CX                          ; if not a Note
    JNZ CpSendExit                  ; then RETURN

    LDS  SI, pError                 ; but if a Note
    CMP  DS:[SI], CX                ; and error is
    JZ   CpSendExit                 ; not eOK (CX = 0)

    PUSH ES                         ; then free its
    CALL FreeMe                     ; memory block

CpSendExit:
    POPF
    POP  BP
    POP  DS
    RET  16
CpSend ENDP

PURGE pError, pMsg, note, messageType, destPID, sourceProcID
$EJECT

;    CpReceive: PROCEDURE (sourceProcID, messageType, timeLimit, pNote, pError) PTR;
;
;    This will allow a process to receive a msg from another process.  The msg must
;    be sent with this pid and the proper type.  TimerLimit allows a proc to wait.

pError       EQU DWORD PTR [BP+8]   ; fifth param
pNote        EQU DWORD PTR [BP+12]  ; fourth param
timeLimit    EQU WORD  PTR [BP+16]  ; third param
messageType  EQU WORD  PTR [BP+18]  ; second param
sourceProcID EQU WORD  PTR [BP+20]  ; first param

; AX is used to store nullword and for comparisons
; DX = source proc ID
; DI = message type
; DS:SI => pPrev (sometimes => error)
; ES:BX => pCur

CpReceive PROC FAR
    PUSH DS
    PUSH BP
    MOV  BP, SP
    PUSHF

    LDS  SI, pError
    MOV  WORD PTR DS:[SI], eOK      ; error := eOK

    CALL CpWhoAmI                   ; save the pointer to the PCB
    PUSH AX                         ; on the stack

    MOV  DS, AX
    MOV  SI, pcbMsgOverlayOffset    ; pPrev = head of the msg queue

    MOV  AX, nullword               ; save nullWord in AX
    MOV  DS:pcbNote, AX             ; preset note to nullword
    MOV  DX, sourceProcID           ; save sourceProcID in DX
    MOV  DI, messageType            ; save messageType in DI

    CLI                             ; disable interrupts

CpRecFindMatchingMsg:
    LES  BX, DS:msgLink[SI]         ; pCur = prev.msgLink

    MOV  CX, ES
    CMP  CX, AX                     ; if reached the end of the
    JE   CpRecNoMessage             ; list then no messages match

CpRecProcMatch:
    CMP  DX, AX                     ; if proc ID is nullword
    JE   CpRecTypeMatch             ; then check for type match
    CMP  DX, ES:msgSource[BX]       ; if proc ID <> cur.procID
    JNE  CpRecFindNextLink          ; then check next element

CpRecTypeMatch:
    CMP  DI, AX                     ; if message type is nullword
    JE   CpRecRemoveMsg             ; then a match has been found
    CMP  DI, ES:msgClass[BX]        ; if msg types = cur.msgType
    JE   CpRecRemoveMsg             ; a match has been found

CpRecFindNextLink:
    MOV  SI, BX
    MOV  CX, ES
    MOV  DS, CX                     ; pPrev = pCur
    JMP  CpRecFindMatchingMsg

CpRecRemoveMsg:
    MOV  AX, ES:[BX+2]
    MOV  DS:[SI+2], AX              ; prev.msgLinkOff = cur.msgLinkOff

    MOV  AX, ES:[BX+4]
    MOV  DS:[SI+4], AX              ; prev.msgLinkSeg = cur.msgLinkSeg

    INC  AX                         ; if the msg removed was not the

    MOV  AX, DS                     ; (save segment of pPrev)
    POP  DS                         ; (restore ptr to pcb)

    JNZ  CpRecGotMessage            ; tail then keep going

    MOV  DS:pcbMsgTailSeg, AX
    MOV  DS:pcbMsgTailOff, SI       ; update pcb.msgTail

CpRecGotMessage:
    DEC  DS:pcbMsgCount             ; decrement number of msgs on queue

    MOV  AX, ES:msgNote[BX]
    LDS  SI, pNote
    MOV  DS:[SI], AX                ; note = msg.note
    JMP  SHORT CpRecCheckForNote

CpRecNoMessage:
    POP  DS                         ; restore ptr to pcb
    MOV  AX, timeLimit              ; if timelimit <> 0
    OR   AX, AX
    JNZ  CpRecTimeCheck             ; wait for message

    LDS  SI, pError                 ; error = eTimeOut
    MOV  WORD PTR DS:[SI], eTimeOut
    JMP  SHORT CpRecReturnNullPtr

CpRecTimeCheck:
    MOV  DS:pcbState, messageWait

    INC  AX                         ; if timeLimit is NULLWORD
    JZ   CpRecAfterTimeCheck        ; wait for message
    DEC  AX

CpRecTimed:
    MOV  DS:pcbState, timedMessageWait

    PUSH AX                         ; push timeLimit
    CALL ComputeTime
    MOV  DS:pcbTimeLimit, AX        ; pcb.timeLimit = ComputeTime

    CALL IncTimedProcesses

CpRecAfterTimeCheck:
    MOV  AX, sourceProcID
    MOV  DS:pcbSource, AX           ; pcb.source = sourceProcID

    MOV  AX, messageType
    MOV  DS:pcbMessageType, AX      ; pcb.messageType = messageType

    LES  AX, pError
    MOV  DS:pcbPErrorSeg, ES        ; pcb.pError = pError
    MOV  DS:pcbPErrorOff, AX

    MOV  AX, roundRobin             ; Reschedule using
    PUSH AX                         ; round robin
    CALL Reschedule

    MOV  AX, DS:pcbNote
    LES  BX, pNote
    MOV  ES:[BX], AX                ; note = pcb.note

    LES  BX, pError
    CMP  WORD PTR ES:[BX], eOK
    JNE  CpRecReturnNullPtr

    MOV  ES, DS:pcbPMessageSeg
    MOV  BX, DS:pcbPMessageOff

CpRecCheckForNote:
    CMP  ES:msgDest[BX], nullWord
    JNE  CpRecExit                  ; if this is a note

    PUSH ES                         ; then free its
    CALL FreeMe                     ; memory block

CpRecReturnNullPtr:
    MOV  AX, nullPtrHigh
    MOV  ES, AX
    MOV  BX, nullPtrLow

CpRecExit:
    POPF
    POP  BP
    POP  DS
    RET  14
CpReceive  ENDP

PURGE pError, pNote, timeLimit, messageType, sourceProcID

CODE ENDS

    END
